﻿Partial Public Class MainPage
    Inherits PhoneApplicationPage

    ' Constructor
    Public Sub New()
        InitializeComponent()

        ' Re-assign names already in the XAML file
        appbarRewindButton = TryCast(Me.ApplicationBar.Buttons(0), ApplicationBarIconButton)
        appbarPlayButton = TryCast(Me.ApplicationBar.Buttons(1), ApplicationBarIconButton)
        appbarPauseButton = TryCast(Me.ApplicationBar.Buttons(2), ApplicationBarIconButton)
        appbarEndButton = TryCast(Me.ApplicationBar.Buttons(3), ApplicationBarIconButton)
    End Sub


    ' ApplicationBar buttons
    Private Sub OnAppbarRewindClick(ByVal sender As Object, ByVal args As EventArgs)
        mediaElement.Position = TimeSpan.Zero
    End Sub


    Private Sub OnAppbarPlayClick(ByVal sender As Object, ByVal args As EventArgs)
        mediaElement.Play()
    End Sub


    Private Sub OnAppbarPauseClick(ByVal sender As Object, ByVal args As EventArgs)
        mediaElement.Pause()
    End Sub


    Private Sub OnAppbarEndClick(ByVal sender As Object, ByVal args As EventArgs)
        mediaElement.Position = mediaElement.NaturalDuration.TimeSpan
    End Sub


    ' MediaElement events
    Private Sub OnMediaElementMediaFailed(ByVal sender As Object, ByVal args As ExceptionRoutedEventArgs)
        errorText.Text = args.ErrorException.Message
    End Sub


    Private Sub OnMediaElementMediaOpened(ByVal sender As Object, ByVal args As RoutedEventArgs)
        appbarRewindButton.IsEnabled = True
        appbarEndButton.IsEnabled = True
    End Sub


    Private Sub OnMediaElementCurrentStateChanged(ByVal sender As Object, ByVal args As RoutedEventArgs)
        statusText.Text = mediaElement.CurrentState.ToString()

        If mediaElement.CurrentState = MediaElementState.Stopped OrElse
            mediaElement.CurrentState = MediaElementState.Paused Then
            appbarPlayButton.IsEnabled = True
            appbarPauseButton.IsEnabled = False
        ElseIf mediaElement.CurrentState = MediaElementState.Playing Then
            appbarPlayButton.IsEnabled = False
            appbarPauseButton.IsEnabled = True
        End If
    End Sub
End Class